(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6021,        181]*)
(*NotebookOutlinePosition[      6691,        204]*)
(*  CellTagsIndexPosition[      6647,        200]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    \(\(sustitucion = {Cos[n*\[Pi]] \[RuleDelayed] \((\(-1\))\)\^n, 
          Sin[n*\[Pi]] \[RuleDelayed] 0};\)\), "\[IndentingNewLine]", 
    \(a[Abs[Sin[x]], x, n_] := \(a[Abs[Sin[x]], x, n] = 
        Integrate[\(1\/\[Pi]\) Abs[Sin[x]] 
              Cos[n*x], {x, \(-\[Pi]\), \[Pi]}, \ 
            Assumptions \[Rule] 
              n \[Element] Integers\  && \ n \[GreaterEqual] \ 0\ ] /. 
          sustitucion\)\)}], "Input"],

Cell[BoxData[
    \(b[Abs[Sin[x]], x, n_] := \(b[Abs[Sin[x]], x, n] = 
        Integrate[\(1\/\[Pi]\) Abs[Sin[x]] 
              Sin[n*x], {x, \(-\[Pi]\), \[Pi]}, \ 
            Assumptions \[Rule] 
              n \[Element] Integers\  && \ n \[GreaterEqual] \ 0\ ] /. 
          sustitucion\)\)], "Input"],

Cell[BoxData[
    \(PoliFourier[f_, var_, n_Integer] := 
      a[f, var, 0]/
          2\  + \ \[Sum]\+\(k = 1\)\%n\((a[f, var, k]*Cos[k*var] + 
              b[f, var, k]*Sin[k*var])\)\)], "Input"],

Cell[BoxData[
    \(\(Table[
        absen[k] = PoliFourier[Abs[Sin[x]], x, k], {k, 6}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(absen[6]\)], "Input"],

Cell[BoxData[
    \(2\/\[Pi] - \(4\ Cos[2\ x]\)\/\(3\ \[Pi]\) - \(4\ Cos[4\ x]\)\/\(15\ \
\[Pi]\) - \(4\ Cos[6\ x]\)\/\(35\ \[Pi]\)\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(Do[Plot[{Abs[Sin[x]], absen[k]}, {x, \(-\[Pi]\), \[Pi]}, 
        PlotRange \[Rule] {\(-\[Pi]\) -  .5, \[Pi] +  .5}, 
        PlotStyle \[Rule] {Hue[0], Hue[ .7]}, 
        Background \[Rule] RGBColor[1, 1, 0.75]], {k, 2, 6}]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[\((\((x\^2/4 + y\^2/9 + z\^2/25)\) /. {x \[Rule] 
                2  \[Rho]\ \ Sin[\[Phi]]\ Cos[\[Theta]], 
              y \[Rule] 3  \[Rho]\ \ Sin[\[Phi]]\ Sin[\[Theta]], 
              z \[Rule] 5\ \[Rho]\ Cos[\[Phi]]})\)*30 \( \[Rho]\^2\) 
        Sin[\[Phi]]*2  \[Rho]\ Sin[\[Phi]]\ Cos[\[Theta]], {\[Rho], 0, 
        1}, {\[Theta], \(-\[Pi]\), \[Pi]}, {\[Phi], 0, \[Pi]/2}]\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[\((\((x\^2/4 + y\^2/9 + z\^2/25)\) /. {x \[Rule] 
                2  \[Rho]\ Sin[\[Phi]]\ Cos[\[Theta]], 
              y \[Rule] 3  \[Rho]\ Sin[\[Phi]]\ Sin[\[Theta]], 
              z \[Rule] 5\ \ \[Rho]\ Cos[\[Phi]]})\)*30 \( \[Rho]\^2\) 
        Sin[\[Phi]]*3  \[Rho]\ Sin[\[Phi]]\ Sin[\[Theta]], {\[Rho], 0, 
        1}, {\[Theta], \(-\[Pi]\), \[Pi]}, {\[Phi], 0, \[Pi]/2}]\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[\((\((x\^2/4 + y\^2/9 + z\^2/25)\) /. {x \[Rule] 
                2  \[Rho]\ Sin[\[Phi]]\ Cos[\[Theta]], 
              y \[Rule] 3  \[Rho]\ Sin[\[Phi]]\ Sin[\[Theta]], 
              z \[Rule] 5\ \ \[Rho]\ Cos[\[Phi]]})\)*30 \( \[Rho]\^2\) 
        Sin[\[Phi]]*5  \[Rho]\ Cos[\[Phi]], {\[Rho], 0, 
        1}, {\[Theta], \(-\[Pi]\), \[Pi]}, {\[Phi], 0, \[Pi]/2}]\)], "Input"],

Cell[BoxData[
    \(25\ \[Pi]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[\((1 /. {x \[Rule] 2  \[Rho]\ Sin[\[Phi]]\ Cos[\[Theta]], 
              y \[Rule] 3  \[Rho]\ Sin[\[Phi]]\ Sin[\[Theta]], 
              z \[Rule] 5\ \ \[Rho]\ Cos[\[Phi]]})\)*30 \( \[Rho]\^2\) 
        Sin[\[Phi]], {\[Rho], 0, 1}, {\[Theta], \(-\[Pi]\), \[Pi]}, {\[Phi], 
        0, \[Pi]/2}]\)], "Input"],

Cell[BoxData[
    \(20\ \[Pi]\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(<< Calculus`Integration`\ ;\)\)], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[
      5 \(\@\( 1 - x\^2/4 - y\^2/9\)\) 
        Boole[x\^2/4 + y\^2/9 \[LessEqual] 1], {x, \(-2\), 
        2.5}, {y, \(-3.5\), 3.5}, PlotPoints \[Rule] 40, 
      AspectRatio \[Rule] 1, BoxRatios \[Rule] {1, 1, 1}]\)], "Input"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[
      z \((x\^2/4 + y\^2/9 + z\^2/25)\), {z, 0, 
        5}, {x, \(-2\) \@\(1 - z\^2/25\), 
        2 \@\( 1 - z\^2/25\)}, {y, \(-3\) \@\(1 - x\^2/4 - z\^2/25\), 
        3 \@\( 1 - x\^2/4 - z\^2/25\)}]\)], "Input"],

Cell[BoxData[
    \(25\ \[Pi]\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
AutoGeneratedPackage->None,
WindowSize->{792, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 449, 8, 103, "Input"],
Cell[2157, 60, 307, 6, 83, "Input"],
Cell[2467, 68, 198, 4, 71, "Input"],
Cell[2668, 74, 103, 2, 30, "Input"],

Cell[CellGroupData[{
Cell[2796, 80, 41, 1, 30, "Input"],
Cell[2840, 83, 145, 2, 42, "Output"]
}, Open  ]],
Cell[3000, 88, 258, 4, 50, "Input"],

Cell[CellGroupData[{
Cell[3283, 96, 423, 6, 52, "Input"],
Cell[3709, 104, 35, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3781, 110, 421, 6, 52, "Input"],
Cell[4205, 118, 35, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4277, 124, 406, 6, 52, "Input"],
Cell[4686, 132, 43, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4766, 138, 336, 5, 52, "Input"],
Cell[5105, 145, 43, 1, 29, "Output"]
}, Open  ]],
Cell[5163, 149, 92, 2, 30, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5280, 155, 256, 5, 56, "Input"],
Cell[5539, 162, 137, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5713, 170, 246, 5, 58, "Input"],
Cell[5962, 177, 43, 1, 29, "Output"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

